//
// 27.02.2025 www.satyria.de
//
// getsystem.c
//

#include "mailbox.h"
#include "types.h"
#include "base.h"
#include "printf.h"
#include "time.h"

u32 pInfo[] ALIGN(16) = {
	39*4,
	0,
   Get_depth, // Tag ID
   4, // Buffer Size
   0, // Request Code (0 für Abfrage)
   0, // Antwort (5)
	Get_board_model,
   4, // Buffer Size
   0, // Request Code (0 für Abfrage)
   0, // Antwort (9)
	Get_board_revision,
   4, // Buffer Size
   0, // Request Code (0 für Abfrage)
   0, // Antwort (13)
   Get_board_serial, // Tag ID
   8,               // Buffer Size (64 Bit = 2x 32-Bit-Werte)
   0,               // Request Code (0 für Abfrage)
   0,               // Antwort1 (Lower 32 Bit) (17)
   0,               // Antwort2 (Upper 32 Bit) (18)
	Get_ARM_memory,
   8,               // Buffer Size (64 Bit = 2x 32-Bit-Werte)
   0,               // Request Code (0 für Abfrage)
   0,               // base address in bytes (22)
   0,               // size in bytes (23)
	Get_VC_memory,
   8,               // Buffer Size (64 Bit = 2x 32-Bit-Werte)
   0,               // Request Code (0 für Abfrage)
   0,               // base address in bytes (27)
   0,               // size in bytes (28)
	Get_physical_display, // Tag ID für physische Display-Abmessungen
   8,                   // Buffer Size (2x u32 = 8 Bytes)
   0,                   // Request Code (0 für Abfrage)
   0,                   // Breite (width in pixels) (32)
   0,                   // Höhe (height in pixels) (33)
	Get_pitch,
   4, // Buffer Size
   0, // Request Code (0 für Abfrage)
   0, // Antwort (37)
	
   0x00000000 // End-Tag	
};

void initgetsystem (void)
{

	 uintptr pInfoAddress = (uintptr)pInfo;
    while (TRUE) {
        BcmMailBox_WriteRead(BCM_MAILBOX_PROP_OUT,(u32)pInfoAddress);
        
        if ((pInfo[1] & 0x80000000) == 0)
        {
			  //printf("Mailbox-Fehler: Antwortflag nicht gesetzt!\n");
			  //printf ("Ergebnisse: %d,%d,%d,%d,%d\n",pInfo[1],pInfo[2],pInfo[3],pInfo[4],pInfo[5]);
			wait(0x300000);
		  }
		  else
		  {
            break;
        }
    }
			  //printf ("Ergebnisse (kein Fehler): %d,%d,%d,%d,%d\n",pInfo[1],pInfo[2],pInfo[3],pInfo[4],pInfo[5]);

}

u32 GetDepth(void)
{
	return pInfo[5];
}

u32 GetBoardModel(void)
{
	return pInfo[9];
}

u32 GetBoardRevision(void)
{
	return pInfo[13];
}

u32 GetDisplayX(void)
{
	return pInfo[32];
}

u32 GetDisplayY(void)
{
	return pInfo[33];
}

u32 GetPitch(void)
{
	return pInfo[37];
}

u32 GetVCMemoryBase(void)
{
	return pInfo[27];
}

u32 GetVCMemorySize(void)
{
	return pInfo[28];
}

u32 GetARMMemoryBase(void)
{
	return pInfo[22];
}

u32 GetARMMemorySize(void)
{
	return pInfo[23];
}

u64 GetBoardSerial(void)
{
	return ((u64)pInfo[18] << 32) | pInfo[17];
}
